﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class PingController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public PingController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpGet]
        public async Task<IActionResult> Get()
        {
            try
            {
                _logger.Info("@@@@ INFO - PPMS Ping Success @@@@");

                using (var response = await _client.GetAsync(await _configuration.GetPingUri()))
                {
                    if (response.IsSuccessStatusCode)
                    {
                        _logger.Info("@@@@@ Info - End GET for Ping @@@@@");
                        return StatusCode(StatusCodes.Status200OK, "Ping!");
                    }

                    _logger.Error($"Ping: Error calling Ping Api. Bad Status Returned: {response.StatusCode}");

                    return StatusCode(StatusCodes.Status500InternalServerError);
                }
            }
            catch (Exception ex)
            {
                _logger.Error($"@@@@ ERROR - PPMS Ping Failure: Exception {ex} @@@@", ex);
                return StatusCode(StatusCodes.Status500InternalServerError, ex);
            }
        }
    }
}